/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.QuiltModel;
import net.mehvahdjukaar.snowyspirit.client.SledModel;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix4f;

public class SledEntityRenderer
extends class_897<SledEntity> {
    private final Map<WoodType, class_2960> textures;
    private final Map<class_1767, class_2960> quiltTextures;
    private final SledModel<SledEntity> model;
    private final SledModel<SledEntity> modelBamboo;
    private final QuiltModel<SledEntity> quiltModel;
    public static final WoodType BAMBOO = (WoodType)WoodTypeRegistry.INSTANCE.get(class_2960.method_12829((String)"bamboo"));

    public SledEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
        this.model = new SledModel(context.method_32167(ClientRegistry.SLED_MODEL));
        this.modelBamboo = new SledModel(context.method_32167(ClientRegistry.SLED_MODEL_BAMBOO));
        this.quiltModel = new QuiltModel(context.method_32167(ClientRegistry.QUILT_MODEL));
        this.textures = (Map)WoodTypeRegistry.INSTANCE.getValues().stream().collect(ImmutableMap.toImmutableMap(e -> e, t -> SnowySpirit.res("textures/entity/sled/" + t.getTexturePath() + ".png")));
        this.quiltTextures = (Map)Stream.of(class_1767.values()).collect(ImmutableMap.toImmutableMap(e -> e, t -> SnowySpirit.res("textures/entity/sled/quilt/" + t.method_7792() + ".png")));
    }

    public void render(SledEntity sled, float yRot, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int light) {
        double dy = class_3532.method_16436((double)partialTicks, (double)sled.prevAdditionalY, (double)sled.cachedAdditionalY);
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.375 + dy, 0.0);
        float xRot = sled.method_5695(partialTicks);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yRot));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(xRot));
        float hurtTme = (float)sled.getHurtTime() - partialTicks;
        float damage = sled.getDamage() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        float zRot = 0.0f;
        if (hurtTme > 0.0f) {
            zRot = class_3532.method_15374((float)hurtTme) * hurtTme * damage / 10.0f * (float)sled.getHurtDir();
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(zRot));
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.125, 0.4);
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        poseStack.method_22904(-0.5, 0.0, -0.5);
        poseStack.method_22909();
        class_2960 resourcelocation = this.getTextureLocation(sled);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        class_4588 vertexconsumer = bufferSource.getBuffer(this.model.method_23500(resourcelocation));
        SledModel<SledEntity> mod = this.getModel(sled);
        mod.method_2828(poseStack, vertexconsumer, light, class_4608.field_21444, -1);
        class_1767 color = sled.getSeatType();
        if (color != null) {
            vertexconsumer = bufferSource.getBuffer(this.model.method_23500(this.quiltTextures.get(color)));
            this.quiltModel.method_2828(poseStack, vertexconsumer, light, class_4608.field_21444, -1);
        }
        poseStack.method_22909();
        this.renderLeash(sled, partialTicks, poseStack, bufferSource, (float)Math.toRadians(90.0f + yRot), (float)Math.toRadians(xRot), (float)Math.toRadians(zRot), dy);
        super.method_3936((class_1297)sled, yRot, partialTicks, poseStack, bufferSource, light);
        if (this.field_4676.method_3958()) {
            this.renderDebugHitbox(poseStack, bufferSource.getBuffer(class_1921.method_23594()), sled, partialTicks);
        }
    }

    public class_2960 getTextureLocation(SledEntity sled) {
        return this.textures.get(sled.getWoodType());
    }

    public SledModel<SledEntity> getModel(SledEntity sled) {
        return sled.getWoodType() == BAMBOO ? this.modelBamboo : this.model;
    }

    private void renderDebugHitbox(class_4587 pMatrixStack, class_4588 pBuffer, SledEntity pEntity, float pPartialTicks) {
        class_238 aabb = pEntity.method_5829().method_997(SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevProjectedPos, pEntity.projectedPos)).method_989(-pEntity.method_23317(), -pEntity.method_23318(), -pEntity.method_23321());
        class_761.method_22982((class_4587)pMatrixStack, (class_4588)pBuffer, (class_238)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (pEntity.hasPuller()) {
            aabb = pEntity.pullerAABB.method_989(-pEntity.method_23317(), -pEntity.method_23318(), -pEntity.method_23321());
            class_761.method_22982((class_4587)pMatrixStack, (class_4588)pBuffer, (class_238)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        class_243 movement = SledEntityRenderer.lerpV(pPartialTicks, pEntity.prevDeltaMovement, pEntity.method_18798());
        class_4587.class_4665 pose = pMatrixStack.method_23760();
        float mult = 6.0f;
        float eye = pEntity.method_5751() + 1.0f + pEntity.cachedAdditionalY;
        pBuffer.method_56824(pose, 0.0f, eye, 0.0f).method_1336(0, 255, 0, 255).method_60831(pose, (float)movement.field_1352, (float)movement.field_1351, (float)movement.field_1350);
        pBuffer.method_56824(pose, (float)(movement.field_1352 * (double)mult), (float)((double)eye + movement.field_1351 * (double)mult), (float)(movement.field_1350 * (double)mult)).method_1336(0, 255, 0, 255).method_60831(pose, (float)movement.field_1352, (float)movement.field_1351, (float)movement.field_1350);
        pBuffer.method_56824(pose, 0.0f, eye + 0.25f, 0.0f).method_1336(255, 0, 255, 255).method_60831(pose, 0.0f, 1.0f, 0.0f);
        pBuffer.method_56824(pose, 0.0f, (float)((double)(eye + 0.25f) + pEntity.misalignedFrictionFactor), 0.0f).method_1336(255, 0, 255, 255).method_60831(pose, 0.0f, 1.0f, 0.0f);
        if (pEntity.boost) {
            movement = movement.method_1029().method_1021(-1.0);
            pBuffer.method_56824(pose, 0.0f, eye, 0.0f).method_1336(255, 255, 0, 255).method_60831(pose, (float)movement.field_1352, (float)movement.field_1351, (float)movement.field_1350);
            pBuffer.method_56824(pose, (float)movement.field_1352, (float)((double)eye + movement.field_1351), (float)movement.field_1350).method_1336(255, 255, 0, 255).method_60831(pose, (float)movement.field_1352, (float)movement.field_1351, (float)movement.field_1350);
        }
    }

    public static class_243 lerpV(float delta, class_243 start, class_243 end) {
        return new class_243(class_3532.method_16436((double)delta, (double)start.field_1352, (double)end.field_1352), class_3532.method_16436((double)delta, (double)start.field_1351, (double)end.field_1351), class_3532.method_16436((double)delta, (double)start.field_1350, (double)end.field_1350));
    }

    private void renderLeash(SledEntity sled, float pPartialTicks, class_4587 poseStack, class_4597 pBuffer, float yRot, float xRot, float zRot, double addY) {
        class_1429 wolf = sled.getSledPuller();
        if (wolf != null) {
            boolean bear = Utils.getID((class_1299)wolf.method_5864()).method_12832().equals("grizzly_bear");
            class_243 wolfPos = wolf.method_30951(pPartialTicks).method_1031(0.0, wolf.method_6109() ? 0.1 : 0.25, 0.0);
            float bbw = wolf.method_17681() / (2.875f + (bear ? 1.5f : 0.0f));
            class_243 sledOffset = new class_243((double)0.4125f, 0.0, (double)0.95f);
            class_243 ropeOffset = new class_243((double)bbw, 0.0, 0.0);
            float cos = class_3532.method_15362((float)yRot);
            float sin = class_3532.method_15374((float)yRot);
            float pCos = class_3532.method_15362((float)xRot);
            float pSin = class_3532.method_15374((float)xRot);
            float wSin = class_3532.method_15374((float)zRot);
            double sledX = class_3532.method_16436((double)pPartialTicks, (double)sled.field_6014, (double)sled.method_23317());
            double sledY = class_3532.method_16436((double)pPartialTicks, (double)sled.field_6036, (double)sled.method_23318());
            double sledZ = class_3532.method_16436((double)pPartialTicks, (double)sled.field_5969, (double)sled.method_23321());
            class_2338 sledEyePos = class_2338.method_49638((class_2374)sled.method_5836(pPartialTicks));
            class_2338 wolfEyePos = class_2338.method_49638((class_2374)wolf.method_5836(pPartialTicks));
            for (int rope = -1; rope <= 1; rope += 2) {
                int index;
                class_4588 vertexconsumer = pBuffer.getBuffer(class_1921.method_23587());
                poseStack.method_22903();
                double wolfOffsetX = (double)cos * ropeOffset.field_1350 + (double)sin * ropeOffset.field_1352 * (double)rope;
                double wolfOffsetZ = (double)sin * ropeOffset.field_1350 - (double)cos * ropeOffset.field_1352 * (double)rope;
                double offsetX = ((double)cos * sledOffset.field_1350 + (double)sin * sledOffset.field_1352 * (double)rope) * (double)pCos;
                double offsetZ = ((double)sin * sledOffset.field_1350 - (double)cos * sledOffset.field_1352 * (double)rope) * (double)pCos;
                double offsetY = (double)(-pSin) * sledOffset.method_1033() + 0.25 + addY - sledOffset.field_1352 * (double)wSin * (double)rope;
                double pX = sledX + offsetX;
                double pY = sledY + offsetY;
                double pZ = sledZ + offsetZ;
                poseStack.method_22904(offsetX, offsetY, offsetZ);
                float deltaX = (float)(wolfPos.field_1352 + wolfOffsetX - pX);
                float deltaY = (float)(wolfPos.field_1351 - pY);
                float deltaZ = (float)(wolfPos.field_1350 + wolfOffsetZ - pZ);
                float width = 0.025f;
                Matrix4f matrix4f = poseStack.method_23760().method_23761();
                float f4 = class_3532.method_48119((float)(deltaX * deltaX + deltaZ * deltaZ)) * width / 2.0f;
                float mathZ = deltaZ * f4;
                float mathX = deltaX * f4;
                int blockLight0 = this.method_24087(sled, sledEyePos);
                class_1937 level = wolf.method_37908();
                int blockLight1 = wolf.method_5809() ? 15 : level.method_8314(class_1944.field_9282, wolfEyePos);
                int skyLight0 = level.method_8314(class_1944.field_9284, sledEyePos);
                int skyLight1 = level.method_8314(class_1944.field_9284, wolfEyePos);
                int maxSegments = 12;
                for (index = 0; index <= maxSegments; ++index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.025f, mathZ, mathX, index, false, maxSegments);
                }
                for (index = maxSegments; index >= 0; --index) {
                    SledEntityRenderer.addVertexPair(vertexconsumer, matrix4f, deltaX, deltaY, deltaZ, blockLight0, blockLight1, skyLight0, skyLight1, 0.025f, 0.0f, mathZ, mathX, index, true, maxSegments);
                }
                poseStack.method_22909();
                if (!(pBuffer instanceof class_4597.class_4598)) continue;
                class_4597.class_4598 bu = (class_4597.class_4598)pBuffer;
                bu.method_22993();
            }
        }
    }

    private static void addVertexPair(class_4588 vertexConsumer, Matrix4f matrix4f, float startX, float startY, float startZ, int blockLight0, int blockLight1, int skyLight0, int skyLight1, float y0, float y1, float dx, float dz, int index, boolean flippedColors, int maxSegments) {
        float segment = (float)index / (float)maxSegments;
        int i = (int)class_3532.method_16439((float)segment, (float)blockLight0, (float)blockLight1);
        int j = (int)class_3532.method_16439((float)segment, (float)skyLight0, (float)skyLight1);
        int light = class_765.method_23687((int)i, (int)j);
        float darker = index % 2 == (flippedColors ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * darker;
        float green = 0.4f * darker;
        float blue = 0.3f * darker;
        float sx = startX * segment;
        float sy = startY > 0.0f ? startY * segment * segment : startY - startY * (1.0f - segment) * (1.0f - segment);
        float sz = startZ * segment;
        vertexConsumer.method_22918(matrix4f, sx - dx, sy + y1, sz + dz).method_22915(red, green, blue, 1.0f).method_60803(light);
        vertexConsumer.method_22918(matrix4f, sx + dx, sy + y0 - y1, sz - dz).method_22915(red, green, blue, 1.0f).method_60803(light);
    }
}

