/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.GingyModel;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.reg.ClientRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_909;

public class GingyEntityRenderer
extends class_909<GingyEntity, GingyModel> {
    private static final Map<class_1767, class_2960> GINGY_TEXTURES = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), d -> SnowySpirit.res("textures/entity/gingerbread_golem/" + d.method_7792() + ".png")));
    private final float scale;

    public GingyEntityRenderer(class_5617.class_5618 context, float scale) {
        super(context, (class_572)new GingyModel(context.method_32167(ClientRegistry.GINGY_MODEL), scale), 0.25f * scale);
        this.scale = scale;
    }

    protected void scale(GingyEntity livingEntity, class_4587 matrixStack, float partialTickTime) {
        matrixStack.method_22905(this.scale, this.scale, this.scale);
    }

    protected float getFlipDegrees(GingyEntity livingEntity) {
        return 0.0f;
    }

    public class_2960 getTextureLocation(GingyEntity entity) {
        return GINGY_TEXTURES.get(entity.getColor());
    }

    protected void setupRotations(GingyEntity entity, class_4587 poseStack, float bob, float yBodyRot, float partialTicks, float scale) {
        super.method_4058((class_1309)entity, poseStack, bob, yBodyRot, partialTicks, this.scale);
        if (entity.field_6213 > 0) {
            float f = ((float)entity.field_6213 + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = class_3532.method_15355((float)f)) > 1.0f) {
                f = 1.0f;
            }
            int deg = entity.isForwardDeathAnim() ? -90 : 90;
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(f * (float)deg));
        }
        float period = 7.853982f * this.scale;
        float limbSwingAmount = 0.0f;
        float walkAnim = 0.0f;
        boolean orderedToSit = entity.isOrderedToSit();
        if (orderedToSit) {
            poseStack.method_22904(0.0, -0.25, 0.0);
        }
        if (!orderedToSit && entity.method_5805()) {
            float maxLimbSwing;
            limbSwingAmount = entity.field_42108.method_48570(partialTicks);
            walkAnim = entity.field_42108.method_48572(partialTicks);
            if (entity.method_6109()) {
                walkAnim *= 3.0f;
            }
            if (limbSwingAmount > (maxLimbSwing = 1.0f)) {
                limbSwingAmount = maxLimbSwing;
            }
        }
        if ((double)limbSwingAmount > 0.001) {
            float angle = walkAnim * ((float)Math.PI * 2 / period);
            float sideSwayPower = 20.0f / this.scale;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15362((float)angle) * sideSwayPower * limbSwingAmount));
        }
    }
}

